<?php
require_once('configuration.php');
require_once('lib/nusoap.php');
require_once('lib.php');

$ns = $path_html;

$server = new soap_server();
$server->configureWSDL('Pedidos', $ns);
$server->wsdl->schemaTargetNamespace = $ns;

$server->register('wsValidaUsuario', array('Usuario' => 'xsd:string', 'Clave' => 'xsd:string'), array('return' => 'xsd:string'), $ns);
$server->register('wsInsertaClienteNuevoDocumento', array('FK_Cliente' => 'xsd:string', 'Nuevo_Documento' => 'xsd:string'), array('return' => 'xsd:string'), $ns);
$server->register('wsInsertaPedido', array('DatosPedido' => 'xsd:string'), array('return' => 'xsd:string'), $ns);
$server->register('wsInsertaCoordenadas', array('DatosCoordenadas' => 'xsd:string'), array('return' => 'xsd:string'), $ns);
$server->register('wsInsertaUsuarioCoordenadas', array('DatosCoordenadas' => 'xsd:string'), array('return' => 'xsd:string'), $ns);
$server->register('wsInsertaDetallePedido', array('DatosDetallePedido' => 'xsd:string'), array('return' => 'xsd:string'), $ns);
$server->register('wsInsertaDocumentoPedido', array('DatosDocumento' => 'xsd:string'), array('return' => 'xsd:string'), $ns);
$server->register('wsInsertaDevoluciones', array('DatosDevolucion' => 'xsd:string'), array('return' => 'xsd:string'), $ns);
$server->register('wsInsertaDevolucionesDetalle', array('DatosDevolucion' => 'xsd:string'), array('return' => 'xsd:string'), $ns);
$server->register('wsGetRutaClientes', array('P_fk_Vendedor' => 'xsd:string', 'P_Dia_Inicio' => 'xsd:string', 'P_Dia_Final' => 'xsd:string'), array('return' => 'xsd:xml'), $ns);
$server->register('wsGetDatosUsuario',array('P_fk_Vendedor' => 'xsd:string'),array('return' => 'xsd:xml'),$ns);
$server->register('wsGetGrupos', array('p_codigo' => 'xsd:string', 'p_sort'  => 'xsd:string'), array('return' => 'xsd:xml'), $ns);
$server->register('wsGetNivelesPrecio', array('p_codigo' => 'xsd:string', 'p_sort'  => 'xsd:string'), array('return' => 'xsd:xml'), $ns);
$server->register('wsGetTiposDocumentos', array('p_codigo' => 'xsd:string', 'p_sort'  => 'xsd:string'), array('return' => 'xsd:xml'), $ns);
$server->register('wsGetProductos', array('p_grupo' => 'xsd:string', 'p_codigo' => 'xsd:string', 'p_sort' => 'xsd:string'), array('return' => 'xsd:xml'), $ns);

function wsInsertaClienteNuevoDocumento($FK_Cliente, $Nuevo_Documento) 
{
	InsertaClienteNuevoDocumento($FK_Cliente, $Nuevo_Documento);
	return '1';
}

function wsInsertaDevoluciones($DatosDevolucion)
{
	$ArrayDevolucion = explode(',', $DatosDevolucion);
	$Datos = InsertaDevoluciones($ArrayDevolucion[0], $ArrayDevolucion[1], $ArrayDevolucion[2], $ArrayDevolucion[3], $ArrayDevolucion[4], $ArrayDevolucion[5]);

	$Valor = $Datos[0]['New_Id'];
	return $Valor;
} //fin

function wsInsertaDevolucionesDetalle($DatosDetalleDevolucion)
{
	$ArrayDevolucion = explode(',', $DatosDetalleDevolucion);
	$Datos = InsertaDevolucionesDetalle($ArrayDevolucion[0], $ArrayDevolucion[1], $ArrayDevolucion[2], $ArrayDevolucion[3], $ArrayDevolucion[4], $ArrayDevolucion[5], $ArrayDevolucion[6], $ArrayDevolucion[7], $ArrayDevolucion[8], $ArrayDevolucion[9], $ArrayDevolucion[10], $ArrayDevolucion[11], $ArrayDevolucion[12]);

	$Valor = $Datos[0]['New_Id'];
	return $Valor;
} //fin	


function wsValidaUsuario($Usuario, $Clave)
{
	$Datos = VerificaUsuario($Usuario, $Clave);
	if ($Datos->EOF) {
		$Valor = "0"; //usuario invalido
	} else {
		$Valor = "1"; //usuario valido
	}
	return $Valor;
} //fin

function wsInsertaPedido($DatosPedido)
{
	$ArrayPedido = explode('|', $DatosPedido);
	$Datos = InsertaPedido($ArrayPedido[0], $ArrayPedido[1], $ArrayPedido[2], $ArrayPedido[3], $ArrayPedido[4], $ArrayPedido[5], $ArrayPedido[6], $ArrayPedido[7], $ArrayPedido[8], $ArrayPedido[9], $ArrayPedido[10], $ArrayPedido[11], $ArrayPedido[12], $ArrayPedido[13]);

	$Valor = $Datos[0]['New_Id'];
	return $Valor;
} //fin

function wsInsertaCoordenadas($DatosCoordenadas)
{
	$ArrayCoordenadas = explode('|', $DatosCoordenadas);
	InsertaCoordenadas($ArrayCoordenadas[0], $ArrayCoordenadas[1], $ArrayCoordenadas[2], $ArrayCoordenadas[3], $ArrayCoordenadas[4]);

	return true;
} //fin

function wsInsertaUsuarioCoordenadas($DatosCoordenadas)
{
	$ArrayCoordenadas = explode('|', $DatosCoordenadas);
	InsertaUsuarioCoordenadas($ArrayCoordenadas[0], $ArrayCoordenadas[1], $ArrayCoordenadas[2]);

	return true;
} //fin

function wsInsertaDetallePedido($DatosDetallePedido)
{
	$ArrayPedido = explode('|', $DatosDetallePedido);
	$Datos = InsertaDetallePedido($ArrayPedido[0], $ArrayPedido[1], $ArrayPedido[2], $ArrayPedido[3], $ArrayPedido[4], $ArrayPedido[5]);

	$Valor = $Datos[0]['New_Id'];
	return $Valor;
} //fin

function wsInsertaDocumentoPedido($DatosDocumento)
{
	$ArrayPedido = explode('\\', $DatosDocumento);
	$Datos = InsertaDocumentoPedido($ArrayPedido[0], $ArrayPedido[1], $ArrayPedido[2]);

	$Valor = $Datos[0]['New_Id'];
	return $Valor;
} //fin

function wsGetRutaClientes($P_fk_Vendedor, $P_Dia_Inicio, $P_Dia_Final)
{
	$rsArray = GetRutaClientes($P_fk_Vendedor, $P_Dia_Inicio, $P_Dia_Final);

	//crear el xml para enviar de regreso

	$Xml = '<?xml version="1.0" encoding="UTF-8" ?>';
	$Xml .= '<Clientes>';
	for ($i = 0; $i < count($rsArray); $i++) {
		$Xml .= '<rec_data>' . $rsArray[$i]['rec_data'] . '</rec_data>';
		// $Xml .='<Nombre>'.$rsArray[$i]['Nombre'].'</Nombre>';
		// $Xml .='<Nombre_Comercial>'.$rsArray[$i]['Nombre_Comercial'].'</Nombre_Comercial>';
		// $Xml .='<Direccion>'.$rsArray[$i]['Direccion'].'</Direccion>';
		// $Xml .='<Direccion_Envio>'.$rsArray[$i]['Direccion_Envio'].'</Direccion_Envio>';
		// $Xml .='<FK_Vendedor>'.$rsArray[$i]['FK_Vendedor'].'</FK_Vendedor>';
		// $Xml .='<Dia_Visita>'.$rsArray[$i]['Dia_Visita'].'</Dia_Visita>';
		// $Xml .='<Codigo_Cobrador>'.$rsArray[$i]['Codigo_Cobrador'].'</Codigo_Cobrador>';
		// $Xml .='<Limite_Credito>'.$rsArray[$i]['Limite_Credito'].'</Limite_Credito>';
		// $Xml .='<Fecha_Apertura>'.$rsArray[$i]['Fecha_Apertura'].'</Fecha_Apertura>';
		// $Xml .='<Nit>'.$rsArray[$i]['Nit'].'</Nit>';
		// $Xml .='<Condicion>'.$rsArray[$i]['Condicion'].'</Condicion>';
		// $Xml .='<Tipo_Pago>'.$rsArray[$i]['Tipo_Pago'].'</Tipo_Pago>';
		// $Xml .='<Total_Cheques_Rech>'.$rsArray[$i]['Total_Cheques_Rech'].'</Total_Cheques_Rech>';
		// $Xml .='<Nivel_Precio>'.$rsArray[$i]['Nivel_Precio'].'</Nivel_Precio>';
		// $Xml .='<Nom_Nivel_Precio>'.$rsArray[$i]['Nom_Nivel_Precio'].'</Nom_Nivel_Precio>';
		// $Xml .='<Clase>'.$rsArray[$i]['Clase'].'</Clase>';
		// $Xml .='<Data_01>'.$rsArray[$i]['Data_01'].'</Data_01>';
		// $Xml .='<Tipo_Autorizacion_Pedidos>'.$rsArray[$i]['Tipo_Autorizacion_Pedidos'].'</Tipo_Autorizacion_Pedidos>';
		// $Xml .='<Referencia>'.$rsArray[$i]['Referencia'].'</Referencia>';
		// $Xml .='<Estado>'.$rsArray[$i]['Estado'].'</Estado>';		
	} //fin for
	$Xml .= '</Clientes>';

	return ($Xml);
} //fin funcion

function wsGetDatosUsuario($P_fk_Vendedor) {
	
	$rsArray = GetDatosVendedor($P_fk_Vendedor);

	$Xml='<?xml version="1.0" encoding="UTF-8" ?>';
	$Xml .= '<Usuario>';
	for($i=0;$i<count($rsArray);$i++)
	{		
		$Xml .='<numero>'.$rsArray[$i]['Numero'].'</numero>';
	}//fin for
	$Xml .= '</Usuario>';
	
	return ($Xml);
}


function wsGetGrupos($p_codigo, $p_sort)
{
	$rsArray = GetGrupos($p_codigo, $p_sort);

	$Xml = '<?xml version="1.0" encoding="UTF-8" ?>';
	$Xml .= '<Grupos>';
	for ($i = 0; $i < count($rsArray); $i++) {
		$Xml .= '<rec_data>' . $rsArray[$i]['rec_data'] . '</rec_data>';
		//$Xml .='<Descripcion>'.$rsArray[$i]['Descripcion'].'</Descripcion>';
		//$Xml .='<Referencia>'.$rsArray[$i]['Referencia'].'</Referencia>';			
		//$Xml .='<Estado>'.$rsArray[$i]['Estado'].'</Estado>';		
	} //fin for
	$Xml .= '</Grupos>';

	return ($Xml);
} //fin

function wsGetNivelesPrecio($p_codigo, $p_sort)
{
	$rsArray = GetNivelesPrecio($p_codigo, $p_sort);

	$Xml = '<?xml version="1.0" encoding="UTF-8" ?>';
	$Xml .= '<NivelesPrecio>';

	for ($i = 0; $i < count($rsArray); $i++) {
		$Xml .= '<rec_data>' . $rsArray[$i]['rec_data'] . '</rec_data>';
		//$Xml .='<Descripcion>'.$rsArray[$i]['Descripcion'].'</Descripcion>';

	} //fin for

	$Xml .= '</NivelesPrecio>';

	return ($Xml);
} //fin


function wsGetTiposDocumentos($p_codigo, $p_sort)
{
	$rsArray = array();
	$rsArray = GetTiposDocumentos($p_codigo, $p_sort);

	$Xml = '<?xml version="1.0" encoding="UTF-8" ?>';
	$Xml .= '<Documentos>';
	for ($i = 0; $i < count($rsArray); $i++) {
		$Xml .= '<rec_data>' . $rsArray[$i]['rec_data'] . '</rec_data>';
		//$Xml .='<Descripcion>'.$rsArray[$i]['Descripcion'].'</Descripcion>';
		//$Xml .='<Forma_Externa>'.$rsArray[$i]['Forma_Externa'].'</Forma_Externa>';			
		//$Xml .='<Estado>'.$rsArray[$i]['Estado'].'</Estado>';		
	} //fin for
	$Xml .= '</Documentos>';

	return ($Xml);
} //fin

function wsGetProductos($p_grupo, $p_codigo, $p_sort)
{
	$rsArray = GetProductos($p_grupo, $p_codigo, $p_sort);

	$Xml = '<?xml version="1.0" encoding="UTF-8" ?>';
	$Xml .= '<Productos>';
	for ($i = 0; $i < count($rsArray); $i++) {
		$Xml .= '<data>' . $rsArray[$i]['data'] . '</data>';
	} //fin for
	$Xml .= '</Productos>';

	return ($Xml);
} //fin

if (!isset($HTTP_RAW_POST_DATA)) $HTTP_RAW_POST_DATA = file_get_contents('php://input');

$server->service($HTTP_RAW_POST_DATA);
