<?php
require_once('lib/nusoap.php');
require_once('parsexml.php');
require_once('../lib.php');
include 'configuration.php';
$ns = "http://derecho.usac.edu.gt/webservice";
$server = new soap_server();
$server->configureWSDL('ConfirmacionDePago', $ns);
$server->wsdl->schemaTargetNamespace = $ns;
$server->register('confirmaPagoCursoVacaciones', array('xml_confirma' => 'xsd:string'), array('return' => 'xsd:string'), $ns);

function confirmaPagoCursoVacaciones($xml_confirma)
{
	$v_retorno = "";
	global $ConnectionDB;
	//return empty( $xml_confirma )  ? new soap_fault('Client','','Ingrese una cadena XML valida') : "Pago registrado:  " . $xml_confirma;
	if (empty($xml_confirma)) {
		$v_retorno = new soap_fault('Client', '', 'XML invalido');
		// retorno con codigo de error --> 0	XML vacio
		$v_retorno = '<RESP_CONFIRMACION><STATUS>0</STATUS><MSG>xml invalido</MSG></RESP_CONFIRMACION>';
	} else {
		// la cadena XML trae datos, tratamos los datos y verificamos si vienen todos los valores requeridos
		$v_datos_confirmacion = simplexml_load_string('<WEB>' . $xml_confirma . $xml_confirma . '<WEB>');

		if (
			$v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['ID_ORDEN_PAGO']['value'] != "" &&
			$v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['CARNET']['value'] != "" &&
			$v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['UNIDAD']['value'] != "" &&
			$v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['EXTENSION']['value'] != "" &&
			$v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['CARRERA']['value'] != "" &&
			$v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['BANCO']['value'] != "" &&
			$v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['NO_BOLETA_DEPOSITO']['value'] != "" &&
			$v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['FECHA_CERTIF_BCO']['value'] != "" &&
			$v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['ID_USUARIO']['value'] != "" &&
			$v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['TIPO_PETICION']['value'] != ""
		) {

			// Verifico la identidad del usuario que consume
			// la clave es CLIENTEDPDUSAC  md5(CLIENTEDPDUSAC) = fd199a03fd9b24cc05dc18fac0d33cf6
			if ($v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['ID_USUARIO']['value'] == 'fd199a03fd9b24cc05dc18fac0d33cf6') {

				// verifico tipo de operacion
				if (trim($v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['TIPO_PETICION']['value']) == '1') {
					// proceso la notificacion de recepcion de pago
					$v_fecha = trim($v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['FECHA_CERTIF_BCO']['value']);
					$v_fecha = substr($v_fecha, 0, 4) . "-" . substr($v_fecha, 4, 2) . "-" . substr($v_fecha, 6, 2);
					$sql_update = " update orden_pago "
						. " set no_boleta_deposito = '" . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['NO_BOLETA_DEPOSITO']['value'] . "',"
						. "     fecha_certif_banco = '" . $v_fecha . "',"
						. "     status_pago = 1,"
						. " 	   fecha_reversion = null,"
						. "     status_reversion = 0 "
						. " where id_orden_pago = " . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['ID_ORDEN_PAGO']['value']
						. "   and carnet = " . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['CARNET']['value']
						. "   and unidad = " . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['UNIDAD']['value']
						. "   and extension = " . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['EXTENSION']['value']
						. "   and carrera = " . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['CARRERA']['value']
						. " ;";
					$r = mysqli_query($ConnectionDB, $sql_update);
					if ($r) {
						$v_retorno = '<RESP_CONFIRMACION><STATUS>1</STATUS></RESP_CONFIRMACION>';
						// registro la bitacora
						$sql_bitacora =  " insert into bitacora(nombre_usuario,fecha,operacion,detalle_operacion) "
							. " values('WebServiceClient DPD','" . date("Y/m/d H:i:s") . "','Registrar Pago de Orden de Pago'"
							. " ,'SIIF-SGI confirmo la recepcion del pago de la orden de pago No."
							. $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['ID_ORDEN_PAGO']['value']
							. " del estudiante con carnet " . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['CARNET']['value'] . "');";
						$result = mysqli_query($ConnectionDB, $sql_bitacora);
					} else {
						$v_retorno = '<RESP_CONFIRMACION><STATUS>0</STATUS><MSG>Error al registrar el pago</MSG></RESP_CONFIRMACION>';
					}
				} else if (trim($v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['TIPO_PETICION']['value']) == '2') {
					// proceso la notificacion de reversion de pago
					$v_fecha = trim($v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['FECHA_CERTIF_BCO']['value']);
					$v_fecha = substr($v_fecha, 0, 4) . "-" . substr($v_fecha, 4, 2) . "-" . substr($v_fecha, 6, 2);

					$sql_update = " update orden_pago "
						. " set fecha_reversion = '" . $v_fecha . "',"
						. "     status_reversion = 1"
						. " where id_orden_pago = " . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['ID_ORDEN_PAGO']['value']
						. "   and carnet = " . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['CARNET']['value']
						. "   and unidad = " . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['UNIDAD']['value']
						. "   and extension = " . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['EXTENSION']['value']
						. "   and carrera = " . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['CARRERA']['value']
						. " ;";

					$r = mysqli_query($ConnectionDB, $sql_update);
					if ($r) {
						$v_retorno = '<RESP_CONFIRMACION><STATUS>1</STATUS></RESP_CONFIRMACION>';
						// registro la bitacora
						$sql_bitacora =  " insert into bitacora(nombre_usuario,fecha,operacion,detalle_operacion) "
							. " values('WebServiceClient DPD','" . date("Y/m/d H:i:s") . "','Registrar Reversion de Orden de Pago'"
							. " ,'SIIF-SGI confirmo la reversion del pago de la orden de pago No."
							. $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['ID_ORDEN_PAGO']['value']
							. " del estudiante con carnet " . $v_datos_confirmacion['WEB']['CONFIRMACION_PAGO'][0]['CARNET']['value'] . "');";
						$result = mysqli_query($ConnectionDB, $sql_bitacora);
					} else {
						$v_retorno = '<RESP_CONFIRMACION><STATUS>0</STATUS><MSG>Error al actualizar la reversion</MSG></RESP_CONFIRMACION>';
					}
				} else {
					// no se pudo determinar el tipo de operacion
					$v_retorno = '<RESP_CONFIRMACION><STATUS>0</STATUS><MSG>Tipo de operacion no soportada</MSG></RESP_CONFIRMACION>';
				}
			} else {
				// Usuario invalido
				$v_retorno = '<RESP_CONFIRMACION><STATUS>0</STATUS><MSG>Usuario invalido</MSG></RESP_CONFIRMACION>';
			}
		} else {
			// retorno con codigo de error --> 0	faltan datos en el XML
			$v_retorno = '<RESP_CONFIRMACION><STATUS>0</STATUS><MSG>Faltan datos en xml</MSG></RESP_CONFIRMACION>';
		}
	}

	return $v_retorno;
}
if (!isset($HTTP_RAW_POST_DATA)) $HTTP_RAW_POST_DATA = file_get_contents('php://input');

$server->service($HTTP_RAW_POST_DATA);
